
clear all
clc

run rev2; %computes equilibrium of the BT model
save('Results','var1','theta1','par0','otherpar0','parmatch0','R1','T1','S1')
clear all; %save and reload all the results from BT used next
load('Results')

%%% Description of "Results"
% 1. Matrix var1 containing all the equilibrium values for the BT model.
% This matrix is passed straight to most functions used subsequently.
% 2. Labor market tightness for the 3 aggr states
% 3-6. Parameters used in the BT calibration
% 7.-9.% The cutoffs for each aggr state: R for endogeneous blowup; T for the level above which a
% vacancy is retained; S for the level below which ojs happens.
%%%

%Create a Grid across productivity levels of ACTIVE matches and compute
%surplus for each level and state
gridsteps=500;
sigma=par0(4);
beta=otherpar0(2);

for p=1:3
    for i=1:gridsteps
        prod(i)=-sigma+i*2*sigma/gridsteps;% grid
        Mall=M(prod(i),par0,parmatch0,var1); %surplus for each idiosyncratic productivity level
        surplus(i,p)=Mall(p); %assigns the right surplus
    end
end

U=ones(gridsteps,1)*(Uvalue(par0,parmatch0,var1))';%Unemployment value for each aggregate state
E=beta.*surplus+U;% use Nash bargain to back out value of employment

% Weights for TableA
% construct a numercial cdf across the productivity levels
% for each shock compute the value of all cdfs FE then assign the right values depending
% on the range in which the shock lies

for p=1:3 %p indexes the state
    
    for i=1:gridsteps
        
        cdfRT=RJL_FERT(prod(i),par0,parmatch0,var1);
        cdfTS=RJL_FETS(prod(i),par0,parmatch0,var1);
        cdfSsig=RJL_FESsig(prod(i),par0,parmatch0,var1);
        
        if prod(i)<=R1(p)
            cdf(i,p)=0;
        else if prod(i)<=T1(p) & prod(i)>R1(p)
                cdf(i,p)=cdfRT(p);
            else if prod(i)>T1(p) & prod(i)<=S1(p)
                    cdf(i,p)=cdfTS(p);
                else if prod(i)>S1(p)
                        cdf(i,p)=cdfSsig(p);
                    else
                    end
                end
            end
        end
    end
end

% convert into weights 
for p=1:3
    pdf(1,p)=cdf(1,p);
    for i=2:gridsteps
        pdf(i,p)=(cdf(i,p)-cdf(i-1,p));
    end
end

%%%PANEL A

%Compute weighted average of losses for all employed assuming they lose
%their job due to an idiosyncratic shock which changes productivity below R
%holding the aggregate state constant

for p=1:3
    Losses_exogenous(p)=100.*(1-(U(:,p)./E(:,p)))'*pdf(:,p); % weight each vector of losses by the appropriate pdf
end

Losses_exogenous
%%%PANEL C

% The Aggregate State Falls. Compute the losses for those who - subsequently and independently - experience
% endogenous destruction, ie a shock rendering idiosyncratic productivity
% below the NEW destruction threshold. Compare to their employment value
% previous to the aggregate shock.



for state_old=1:2
    for state_new=state_old+1:3%
        % identify the relevant part of the grid
        count=0;
        for i=1:gridsteps
            if prod(i)<R1(state_new)
                count=count+1;
            end
        end
        Losses_exogenous_recession(state_old,state_new)=100.*(1-(U(count+1:gridsteps,state_new)./E(count+1:gridsteps, state_old)))'*pdf(count+1:gridsteps,state_old)./(sum(pdf(count+1:gridsteps,state_old)));
    end
end

Losses_exogenous_recession



%%% PANEL D

% Assume the aggregate state falls from 1 to 2 (1 to 3; 2 to 3). Then, all
% matches between R1(state_old) and R1(state_new) are immediately destroyed. Compute the
% associated losses


for state_old=1:3
    for state_new=2:3
        
        % identify the relevant parts of the grid ie the destroyed matches.
        count=0;
        for i=1:gridsteps
            if prod(i)<R1(state_new) %count up the grid
                count=count+1;
            end
        end
        
        Losses_endogenous(state_old,state_new)=100.*(1-(U(1:count,state_new)./E(1:count,state_old)))'*pdf(1:count,state_old)./(sum(pdf(1:count,state_old)));
        
    end
end

Losses_endogenous


%%% COMPUTE JOB DESTRUCTION RATES FOR THE Panels

% Job Destruction for Panel A
lambda=par0(2);
for p=1:3
    jd_exogenous(p)=100*lambda*((R1(p)-(-sigma))./(2*sigma)); % shock prob times prob to draw below destruction threshold
end

jd_exogenous

%Job Finding Rate for an Unemployed Searcher

jfr=theta1.*q(theta1,parmatch0)

%check that inflow equals outflow
jd_exogenous'./100.*(1-u(par0,parmatch0,var1))-u(par0,parmatch0,var1).*jfr./((ones(3,1)*sigma-T1)./(2*sigma))


% vacancy filling rate
vfr=q(theta1,parmatch0)

% JD for Exercise 2

count=zeros(3,3);
for state_old=1:3
    for state_new=2:3
        
        %again identify the relevant "groups"
        for i=1:gridsteps
            if prod(i)<R1(state_new)
                count(state_old,state_new)=count(state_old,state_new)+1;
            end
        end
        % compute jd_rate conditional on aggregate shockas the mass in the
        % affected productivity range
        jd_endogenous(state_old,state_new)=100*sum(pdf(1:count(state_old,state_new), state_old));
    end
end


jd_endogenous

% JD for Exercise 3

jd_recession=(ones(3,1)*jd_exogenous).*(1-jd_endogenous./100)
% The inflow rate is taken with respect to the employed previous to the
%aggregate shock. Take out those who get fired immediately. The rest
%experiences a rate like in Panel A. NOTE: Just the upper triangular used.




